USE BMS_EIS

INSERT INTO TRAIT VALUES ('HIDE_SPECIALTY_WHITEBOARD', 'HIDE_SPECIALTY_WHITEBOARD', 'Trait for wards to determine if specialty should display on whiteboard.', 'active', NULL, 'TraitStatus', 'active', 'ST', '2.16.840.1.113883.5.1007', 'DataType', 'Character String', 1, NULL)
GO

DECLARE @whiteboardTraitId INT
SELECT @whiteboardTraitId = PK_TRAIT FROM TRAIT WHERE IDENTIFIER = 'HIDE_SPECIALTY_WHITEBOARD'
INSERT INTO TRAIT_ASSIGNMENT_ENTITY_TYPE VALUES (0, 3, @whiteboardTraitId, 'active', NULL, 'Status', 'active', NULL)
GO


INSERT INTO TRAIT VALUES ('HIDE_SPECIALTY_DESKTOP', 'HIDE_SPECIALTY_DESKTOP', 'Trait for wards to determine if specialty should display on PPBP Views.', 'active', NULL, 'TraitStatus', 'active', 'ST', '2.16.840.1.113883.5.1007', 'DataType', 'Character String', 1, NULL)
GO


DECLARE @desktopTraitId INT
SELECT @desktopTraitId = PK_TRAIT FROM TRAIT WHERE IDENTIFIER = 'HIDE_SPECIALTY_DESKTOP'
INSERT INTO TRAIT_ASSIGNMENT_ENTITY_TYPE VALUES (0, 3, @desktopTraitId, 'active', NULL, 'Status', 'active', NULL)
GO


INSERT INTO TRAIT VALUES ('IS_VIRTUAL_WARD', 'IS_VIRTUAL_WARD', 'Trait for wards to determine if this is a ward accessed and configured in BMS only (Non-VistA).', 'active', NULL, 'TraitStatus', 'active', 'ST', '2.16.840.1.113883.5.1007', 'DataType', 'Character String', 1, NULL)
GO

DECLARE @virtualTraitId INT
SELECT @virtualTraitId = PK_TRAIT FROM TRAIT WHERE IDENTIFIER = 'IS_VIRTUAL_WARD'
INSERT INTO TRAIT_ASSIGNMENT_ENTITY_TYPE VALUES (0, 3, @virtualTraitId, 'active', NULL, 'Status', 'active', NULL)
GO


INSERT INTO TRAIT VALUES ('CENSUS_CATEGORY', 'CENSUS_CATEGORY', 'Trait for wards to determine which census category to group them in.', 'active', NULL, 'TraitStatus', 'active', 'ST', '2.16.840.1.113883.5.1007', 'DataType', 'Character String', 1, NULL)
GO

DECLARE @censusCategoryTraitId INT
SELECT @censusCategoryTraitId = PK_TRAIT FROM TRAIT WHERE IDENTIFIER = 'CENSUS_CATEGORY'
INSERT INTO TRAIT_ASSIGNMENT_ENTITY_TYPE VALUES (0, 3, @censusCategoryTraitId, 'active', NULL, 'Status', 'active', NULL)
GO


INSERT INTO TRAIT VALUES ('ASSIGNED_VIRTUAL_WARD', 'ASSIGNED_VIRTUAL_WARD', 'Trait for wards to show which virtual ward they are assigned to.', 'active', NULL, 'TraitStatus', 'active', 'ST', '2.16.840.1.113883.5.1007', 'DataType', 'Character String', 1, NULL)
GO

DECLARE @virtualWardTraitId INT
SELECT @virtualWardTraitId = PK_TRAIT FROM TRAIT WHERE IDENTIFIER = 'ASSIGNED_VIRTUAL_WARD'
INSERT INTO TRAIT_ASSIGNMENT_ENTITY_TYPE VALUES (0, 3, @virtualWardTraitId, 'active', NULL, 'Status', 'active', NULL)
GO